#ifndef _ltc1859spi_h_
#define _ltc1859spi_h_ 1


//Use these by ORing the Command and the Address together and sending as first byte


/* 
** SPI Channel Settings
** S/D: Single Ended / ~Differential
** O/S: Odd (single) / ~Sign (diff)
** S1: Channel bit 1
** S0: Channel bit 0
** Defined as the top nibble of the data byte
*/
#define LTC1859_DIFF_01                    (0x00)
#define LTC1859_DIFF_23                    (0x10)
#define LTC1859_DIFF_45                    (0x20)
#define LTC1859_DIFF_67                    (0x30)
#define LTC1859_DIFF_10                    (0x40)
#define LTC1859_DIFF_32                    (0x50)
#define LTC1859_DIFF_54                    (0x60)
#define LTC1859_DIFF_76                    (0x70)
#define LTC1859_SING_0                     (0x80)
#define LTC1859_SING_1                     (0xC0)
#define LTC1859_SING_2                     (0x90)
#define LTC1859_SING_3                     (0xD0)
#define LTC1859_SING_4                     (0xA0)
#define LTC1859_SING_5                     (0xE0)
#define LTC1859_SING_6                     (0xB0)
#define LTC1859_SING_7                     (0xF0)



/* 
** SPI Span Codes
** Defined as the bottom bits 3 and 2 of the first byte
*/
#define LTC1859_SPAN_BIPOLAR_5_5                  (0x00)
#define LTC1859_SPAN_BIPOLAR_10_10                (0x04)
#define LTC1859_SPAN_UNIPOLAR_0_5                 (0x08)
#define LTC1859_SPAN_UNIPOLAR_0_10                (0x0C)


/* 
** SPI Sleep settings
** Defined as the bottom bits 1 and 0 of the first byte
*/
#define LTC1859_POWER_ON                   (0x00)
#define LTC1859_NAP                        (0x02)
#define LTC1859_SLEEP                      (0x01)


//Channel Lookup
static const uint_8 LTC1859ChannelSelect[] = 
{
    LTC1859_DIFF_01,
	LTC1859_DIFF_23,
	LTC1859_DIFF_45,
	LTC1859_DIFF_67,
	LTC1859_DIFF_10,
	LTC1859_DIFF_32,
	LTC1859_DIFF_54,
	LTC1859_DIFF_76,
	LTC1859_SING_0,
	LTC1859_SING_1,
	LTC1859_SING_2,
	LTC1859_SING_3,
	LTC1859_SING_4,
	LTC1859_SING_5,
	LTC1859_SING_6,
	LTC1859_SING_7
};

//Span Lookup
static const uint_8 LTC1859SpanSelect[] = 
{
	LTC1859_SPAN_BIPOLAR_5_5,
	LTC1859_SPAN_BIPOLAR_10_10,
	LTC1859_SPAN_UNIPOLAR_0_5,
	LTC1859_SPAN_UNIPOLAR_0_10
};



//Sleep Lookup
static const uint_8 LTC1859StateSelect[] = 
{
	LTC1859_POWER_ON,
	LTC1859_NAP,
	LTC1859_SLEEP
};


//Function Definitions

extern uint_32		send_receive_LTC1859 (uint_8, uint_8, uint_8, FILE_PTR);


#endif /* _ltc1859i2c_h_ */
